## log.mrc
## advanced logging - see the readme for help
## v1.0 - ash (ash@scripters-austnet.org)
alias log {
  if ($left($1,1) == -) { var %s = $1 | tokenize 32 $2- }
  if ($1 == reload) {
    if (q !isin %s) { logecho reloading logfile }
    if ($hget(log)) { hfree log }
    hmake log 20
    if ($exists($logfile)) {
      var %c = 1
      while (%c <= $lines($logfile)) {
        hadd log $logid $read($logfile,%c)
        inc %c
      }
    }
    else {
      write $logfile
      if (q !isin %s) { logecho no logfile found - a blank one was created }
    }
  }
  if ($1 == add) {
    write $logfile $2-
    if ($hget(log)) { hadd log $logid $2- }
  }
  if ($1 == list) {
    if ($hget(log)) {
      var %d = $hget(log,0).item
      if (%d) {
        logecho there $iif(%d == 1,is,are) %d active logging rule $+ $iif(%d > 1,s)     
        var %c = 1
        while (%c <= %d) {
          logecho %c $+ : $hget(log,%c).data
          inc %c
        }      
      }
      else {
        logecho no active logging rules
      }
    }
    else {
      logecho the logger is not currently running - to start it do /log restart
    }
  }
  if ($1 == flush) {
    .remove $logfile
    hdel -w log *
  }
  if ($1 == del) || ($1 == delete) {
    if ($2 isnum) {
      if ($hget(log,$2).item) {
        if (q !isin %s) { logecho deleted $2 $+ : $hget(log,$2).data }
        hdel log $hget(log,$2).item
        write -d $+ $2 $logfile
      }
    }
    else {
      var %c = 1
      while (%c <= $hget(log,0).item) {
        if ($hget(log,%c).data == $2-) {
          logecho deleted: %c $+ :  $ifmatch
          hdel log $hget(log,%c).item
          write -d $+ %c $logfile
        }
        inc %c
      }
    }
  }
  halt
}
alias logecho {
  echo $colour(info) -ta log: $1-
}
alias logid {
  if ($hget(log)) {
    var %c = 1
    var %t = 0
    while (%c <= $hget(log,0).item) {
      if ($right($hget(log,%c).item,-1) > %t) {
        %t = $ifmatch
      }  
      inc %c
    }
    return $+(r,$calc(%t + 1))
  }
}
on *:START:{
  log -q reload
}
alias logparse {
  var %c = 1
  while (%c <= $hget(log,0).item) {
    var %r = $hget(log,%c).data
    var %e = $gettok(%r,$calc($findtok(%r,log,32) + 1),32)
    if ($log.event($1,%e)) {
      var %t = $gettok(%r,$calc($findtok(%r,in,32) + 1),32)
      if ($log.target($2,%t)) {
        var %n = $gettok(%r,$calc($findtok(%r,from,32) + 1),32)     
        if ($log.from($3,$2,%n)) {
          var %o = $gettok(%r,$calc($findtok(%r,to,32) + 1),32)
          var %f = $gettok(%r,$calc($findtok(%r,to,32) + 2),32)
          var %options = $gettok(%r,$+($calc($findtok(%r,to,32) + 3),-),32)
          var %log = $log.line($1,$2,$3,$4,$5,$6)
if ($istok(%options,strip,32)) { %log = $strip(%log) }
if (!$istok(%options,notimestamp,32)) { %log = $timestamp %log }
          if (%o == file) {
            write $replace(%f,&t,$2,&n,$3,&w,$network) %log
          }
          if (%o == window) {
            echo %f %log
          }
          if (%o == irc) {
            .msg %f %log
          }
          if (%o == command) {
            %f %log
          }
        }
      }
    }
    inc %c
  }
}
alias log.event {
  var %c = 1
  while (%c <= $numtok($2,44)) {
    var %t = $gettok($2,%c,44)
    if (%t == all) { return $true }
    if ($1 == %t) { return $true }
    if (($left(%t,1) == !) && ($right(%t,-1) == $1)) { return $false }
    inc %c
  }
}
alias log.target {
  var %t2 = 1
  var %tc
  while (%t2 <= $numtok($2,44)) {
    %tc = $gettok($2,%t2,44)
    if (($iif($left($1,1) == $chr(35),$chr(35),?) == %tc) || ($1 == %tc)) { return $true }
    if (($left(%tc,1) == !) && ($right(%tc,-1) == $1)) { return $false }
    inc %t2
  }
}
alias log.from {
  var %t2 = 1
  var %tc
  while (%t2 <= $numtok($3,44)) {
    %tc = $gettok($3,%t2,44)
    if ($left(%tc,1) == @) { if ($1 !isop $2) { inc %t2 | continue } | else { %tc = $right(%tc,-1) } }
    if ($left(%tc,1) == +) { if ($1 !isvo $2) { inc %t2 | continue } | else { %tc = $right(%tc,-1) } }
    if (%tc iswm $1) { return $true }
    inc %t2
  }
}
alias log.line {
  if ($1 == text) {
    return < $+ $3 $+ > $4
  }
  if ($1 == notice) {
    if ($left($2,1) == $chr(35)) {
      return - $+ $3 $+ : $+ $2 $+ - $4
    }
    else {
      return - $+ $3 $+ - $4
    }
  }
  if ($1 == action) {
    return * $3 $4
  }
  if ($1 == join) {
    return *** $3 ( $+ $4 $+ ) has joined $2 
  }
  if ($1 == part) {
    return *** $3 ( $+ $4 $+ ) has left $2 
  }
  if ($1 == kick) {
    return *** $5 was kicked $3 ( $+ $6 $+ )
  }
  if ($1 == quit) {
    return *** $3 ( $+ $4 $+ ) quit IRC ( $+ $5 $+ )
  }
  if ($1 == nick) {
    return *** $3 ( $+ $4 $+ ) is now known as $5
  }
  if ($1 == mode) {
    return *** $3 sets mode $5
  }
}
on *:rawmode:#:{
  return $logparse(mode,$target,$nick,$address,$1-)
}
on *:text:*:*:{
  return $logparse(text,$target,$nick,$1-,$address)
}
on *:notice:*:*:{
  return $logparse(notice,$target,$nick,$1-,$address)
}
on *:input:*:{
  if ($left($1,1) != /) { return $logparse(text,$target,$me,$1-,$address) }
}
on *:action:*:*:{
  return $logparse(action,$target,$nick,$1-,$address)
}
on *:join:#:{
  return $logparse(join,$chan,$nick,$address)
}
on *:part:#:{
  return $logparse(part,$chan,$nick,$address)
}
on *:kick:#:{
  return $logparse(kick,$chan,$nick,$address,$knick,$1-)
}
on *:quit:{
  var %c = 1
  while ($comchan($nick,%c)) {
    nulll $logparse(quit,$ifmatch,$nick,$address,$1-)
    inc %c
  }
}
on *:nick:{
  var %c = 1
  while ($comchan($newnick,%c)) {
    nulll $logparse(nick,$ifmatch,$nick,$address,$newnick)
    inc %c
  }
}
alias nulll return
alias logfile { return log.db }
